#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdbool.h>


#define F_CPU 20000000UL
#include <util/delay.h>

#define xHallInPIN  PIND
#define xHallInPORT PORTD
#define xHallInDDR  DDRD
#define xHallInBit  2



#define xMagnetOutPORT PORTD
#define xMagnetOutDDR  DDRD
#define xMagnetOutBit  3


void xIOinit(){
  xMagnetOutDDR |= _BV(xMagnetOutBit) ;
  xMagnetOutPORT &= ~ _BV(xMagnetOutBit) ;
 
  xHallInDDR &= ~ _BV(xHallInBit) ;
  xHallInPORT |= _BV(xHallInBit) ;
  }

//---------------------------------------------------------------- 

void uartPutc( char c){
  while (!(UCSR0A & (1<<UDRE0))); 
  UDR0 = c;            
  }

/*
void uartPutc(char c){
   while (!(UCSR0A & (1<<UDRE0))); 
   UDR0 = c;                      
   }
*/
void uartPutsPgm(const char *progmem_s){
  register char c;
  while ( (c = pgm_read_byte(progmem_s++)) ) { 
    uartPutc(c); 
	}
  }

void exit(int k){
  uartPutsPgm(PSTR("exit")) ;
  for(;;){}
  }

void uartBlank(){
  uartPutc(' ') ; 
  }

void uartCrlf(){
  uartPutc(13) ; 
  uartPutc(10) ;
  }


void uartPutsPgmCR(const char *progmem_s){
  uartPutsPgm(progmem_s) ;
  uartCrlf() ;
  }



/*
void uartLf(){
  uartPutc(13) ; 
  }
*/

void uartHex(uint8_t v){
  v &=0b00001111 ;
  if (v<=9) { uartPutc('0'+v) ; } 
       else { uartPutc(v+'A'-10) ; } ;
  }

void uartByte(uint8_t v){
  uartHex(v>>4) ; 
  uartHex(v) ; 
  }

void uartWord(uint16_t v){
  uartByte(v>>8) ; 
  uartByte(v) ; 
  }

void uartDword(uint32_t v){
  uartWord(v>>16) ; 
  uartWord(v) ; 
  }


/*
void uartUint32(uint32_t v){
  uartWord(v>>16) ; 
  uartWord(v) ; 
  }
*/

void uartDecOut(int k){
  if (k<0) { k=-k ; uartPutc('-') ; } else { uartPutc(' ') ; }
  uartPutc( ((k/1000) % 10)+48 ) ;
  uartPutc( ((k/100) % 10)+48 ) ;
  uartPutc( ((k/10) % 10)+48 ) ;
  uartPutc( (k % 10)+48 ) ;
//   uartPutc(32) ;
  }

void uartDecOut32(int32_t k){
  if (k<0) { k=-k ; uartPutc('-') ; } else { uartPutc(' ') ; }
  uartPutc( ((k/10000000L) % 10)+48 ) ;
  uartPutc( ((k/1000000L) % 10)+48 ) ;   
  uartPutc( ((k/100000L) % 10)+48 ) ;  
  uartPutc( ((k/10000L) % 10)+48 ) ;
  uartPutc( ((k/1000L) % 10)+48 ) ;
  uartPutc( ((k/100L) % 10)+48 ) ;
  uartPutc( ((k/10L) % 10)+48 ) ;
  uartPutc( (k % 10L)+48 ) ;
//   uartPutc(32) ;
  }

// RS232 RX routines


uint8_t uartGetc(void){
 // while (!(UCSRA & (1<<RXC)));  
 // return UDR ;                   
  
  while (!(UCSR0A & (1<<RXC0)));  
  return UDR0 ;                   
  }

uint8_t uartGetcEcho(void){
  char c ;
  c=uartGetc() ;
  uartPutc(c) ;
  return(c) ;
  }

uint8_t uartChkc(void) {
  //return (UCSRA & (1<<RXC)) ;  //  Zeichen verfuegbar ?
   return (UCSR0A & (1<<RXC0)) ;  //  Zeichen verfuegbar ?
  }



void DelayMs(uint16_t x){
  uint16_t k ;
  for (k=0 ; k<x ; k++ ) { 
     _delay_ms(1) ;
    }
  }

//----------------------------------------------------------------


void autoRun(){
  while(1){
    xMagnetOutPORT |= _BV(xMagnetOutBit) ; 
	DelayMs(10) ;
    xMagnetOutPORT &= ~ _BV(xMagnetOutBit) ;
	DelayMs(40) ;
    }
  }


void timer1Init(){

  TCCR1A=0b10000010 ; // fast pwm  output
  TCCR1B=0b00011001	; // ck=XTAL
// no Interupt enable for Timer1-Overflow
//  TIMSK1=0b00000001 ;
  OCR1A=77 ;
  ICR1=154-1 ; // sample period predivider 
  }

void timer0Init(){

  TCCR0A=0b00100011 ; // fast pwm  output OCR0B OC0B=PD5 pin 11of28
  TCCR0B=0b00001001	; // ck=XTAL
// no Interupt enable for Timer1-Overflow
//  TIMSK1=0b00000001 ;
  OCR0B=77 ;
  OCR0A=154-1 ; // sample period predivider 
  }

volatile uint16_t timeCount1 ;

int Dt,T ;

ISR(TIMER1_OVF_vect) {
//   IO4port |=  _BV(IO4pin) ;
 
//  IO4port &= ~ _BV(IO4pin) ;
  }

//----------------------------------------------------------------------------------------



//----------------------------------------------------------------
int main(){

  DDRD =0b11111110 ; // enable outputs , bit 0,1=input
  PORTD=0b11111111 ; // pullups on on input pins
  
  DDRB =0b11111111 ; // enable outputs 
  PORTB=0b11111111 ; // pullups on on input pins





// 16.00MHz/19200/16=52
// 20MHz/16/115200=11
  UCSR0B |= ( 1 << TXEN0 ) | ( 1 << RXEN0 ) ;					// UART TX einschalten
  // UCSR0C |= ( 1 << URSEL )|( 3<<UCSZ0 );	    // Asynchron 8N1
  UBRR0H  = 0;                               // Highbyte ist 0
  UBRR0L  = 11-1 ;                             // 115200 Bit/sec
  


  timer0Init() ;

  uartCrlf() ; 
   uartPutsPgm(PSTR("Start")) ;


  while(1){
   
    } ;
  return(0) ;
 }



